/*------------------------------------------------------------------------------*
 * File Name: MatricesEx.c														*
 * Creation: GJL 4/1/2005														*
 * Purpose: OriginC Source C file containing a matrix examples.					*
 * Copyright (c) OriginLab Corp.	2005, 2006, 2007, 2008, 2009, 2010			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>

void matrixLowerCasemEx()
{
	int ii, jj, nSum;
	matrix<int> mInts = {{1,2,3}, {4,5,6}, {7,8,9}}, mCopy;
	mCopy = mInts;

	vector<int> vColSums, vRowSums;
	mCopy.SumColumns(vColSums);
	mCopy.Transpose();
	mCopy.SumColumns(vRowSums);
	vRowSums.Sum(nSum);

	printf("mInts:\n");
	for(ii = 0; ii < mInts.GetNumRows(); ii++)
	{
		for(jj = 0; jj < mInts.GetNumCols(); jj++)
			printf("%d\t", mInts[ii][jj]);
		printf("| %d\n", vRowSums[ii]);
	}
	printf("---\t---\t---\t-----\n");
	for(jj = 0; jj < vColSums.GetSize(); jj++)
		printf("%d\t", vColSums[jj]);
	printf("| %d\n", nSum);
}

/**
	This example shows how to set all cells outside of a
	circular area in a matrix to a particular value. It
	is assumed that a square matrix is active.
*/
void MatrixUpperCaseMEx(double dOutsideVal = 0)
{
	// Declare matrix layer and check validity
	MatrixLayer ml = Project.ActiveLayer();
	if( !ml )
	{
		out_str("Active layer is not a matrix");
		return;
	}

	// Declare matrix object and get dimensions
	Matrix mm(ml);
	int nRows = mm.GetNumRows();
	int nCols = mm.GetNumCols();
	if( nRows != nCols )
	{
		out_str("Matrix is not a square matrix");
		return;
	}
	int nrc = 0.5 + nRows/2.0; // nearest int
	int ncc = 0.5 + nCols/2.0;
	double rr = min(nrc, ncc);

	// Loop over all cells
	for(int nr = 0; nr < nRows; nr++)
	{
		for(int nc = 0; nc < mm.GetNumCols(); nc++)
		{
			double xsqr = (nr - nrc)^2;
			double ysqr = (nc - ncc)^2;
			if(sqrt(xsqr + ysqr) > rr)
			{
				mm[nr][nc] = dOutsideVal;
			}
		}
	}
}
